#include <Constants.au3>
#include <AutoItConstants.au3>
#RequireAdmin


; Priston Tale fast logger
; www.autoclip.net  2016-2021

;--------------------------------------
; TO RUN THIS SCRIPT you need AutoIt
;  get it at:   www.autoitscript.com
;
; NOTE:
; PristonTale must be in WINDOW mode
;     borderless at 1920x1080 res
;
;  Put server after command..
;       val/awell/mid/bc
;--------------------------------------


Opt("MouseCoordMode", 2)
Opt("PixelCoordMode", 2)
Opt("WinWaitDelay", 100)
Opt("MouseClickDownDelay",100)
local $app, $hWin, $txt, $svr, $x, $y, $checkTypo, $typos
local $winChecksum



$PTfolder = "c:\pristontale\"                        ;    PT folder            --IMPORTANT--
$Login = "fdghfdgh"                                  ;    PT login ID
$PassW = "dfhfghdfgh"                                ;    PT password



If Not IsAdmin() Then
  MsgBox($MB_SYSTEMMODAL, "GoGoPT", "Script needs admin rights")
  Exit
EndIf

HotKeySet("{Esc}", "captureEsc")     ;  press <Esc> to stop script
Func captureEsc()
    Sleep(500)
    Exit
EndFunc


; check server parameter (default = valento)

 if number( $CmdLine[0]) > 0 then
   $svr = $CmdLine[1]
 Endif

 Switch String($svr)
   case "val"
   case "awell"
   case "mid"
   case "bc"
   case else
	  $svr = "val"
 EndSwitch



 $app = "Priston Tale"
 FileChangeDir ($PTfolder)
 Run("game.exe")
 $hWin = WinWaitActive($app, "", 60)		; wait for login panel
 Sleep(1000)


 If Not WinExists($app) Then
    MsgBox($MB_SYSTEMMODAL, "GoGoPT", "Game is not running")
	Exit
 EndIf

 Sleep(500)
 WinSetState ($app, "", @SW_HIDE )
 Sleep(1500)
 WinSetState ($app, "", @SW_SHOW )
 Sleep(500)
 Send ("  ")

 $typos = 0
 While $typos < 10		;   when login panel is slow to load the login may be typed incorrectly
      Send($Login)
	  Sleep(20)
	  Send("+{HOME}")		;  read it back and check
	  Sleep(20)
	  Send("^c")
	  Sleep(20)
	  $checkTypo = ClipGet()
	  ClipPut("")
	  If $checkTypo = $Login Then
		 $typos = 100
	  Else
		 $typos = $typos + 1
		 Beep(700,200)
	     Sleep(1500)
	  EndIf
 WEnd


 Send("^{END}{TAB}")

 $typos = 0
 While $typos < 5
      Send($PassW)
	  Sleep(20)
	  Send("+{HOME}")
	  Sleep(20)
	  Send("^c")
	  Sleep(20)
	  $checkTypo = ClipGet()
	  ClipPut("")
	  If $checkTypo = $PassW Then
		 $typos = 100
	  Else
		 $typos = $typos + 1
		 Beep(700,200)
	     Sleep(750)
	  EndIf
 WEnd


 $winChecksum = PixelChecksum(870, 530, 970, 600)
 Send("{ENTER}")

 While $winCheckSum = PixelChecksum(870, 530, 970, 600)	   ;  wait for next panel
   Sleep(100)
 WEnd


; click on Select Server panel (at 1920 res)
;	for Val server	 960, 696
;	for Awell svr	 960, 717
;	for Mid svr		 960, 739
;	for BC svr		 960, 761

 $x = 960
 Switch String($svr)
   case "val"
	  $y = 696
   case "awell"
	  $y = 717
   case "mid"
	  $y = 739
   case "bc"
	  $y = 761
 EndSwitch


 Sleep(1000)
 MouseMove (700, 300)
 MouseMove (1100, 800)
 MouseMove (800, 600)
 MouseMove (1200, 400)
 MouseMove (900, 770)

 MouseMove ($x, $y)
 Sleep(700)
 $winChecksum = PixelChecksum(870, 530, 970, 600)


 MouseClick ($MOUSE_CLICK_PRIMARY)
 Sleep(500)
 MouseClick ($MOUSE_CLICK_PRIMARY)

; wait for char select panel
 While $winCheckSum = PixelChecksum(870, 530, 970, 600)
	MouseMove (870, 530)
	MouseMove (970, 530)
	MouseMove (970, 600)
	MouseMove (870, 600)
    Sleep(200)
 WEnd



; click on Select Char panel

;		for left centre char        880, 600
;		for right centre char       1040, 600
;		for far left char           630, 600
;		for middle left char        743, 600
;		for middle right char       1177, 600
;		for far right char          1290, 600

 MouseMove (1040, 600)       ;   change this line to select a different char     <<<<<<--   WHICH CHAR ??


;  select char
;  click slowly to to avoid clan bug
 Sleep(300)
 MouseClick ($MOUSE_CLICK_PRIMARY)
 Sleep(800)
 MouseClick ($MOUSE_CLICK_PRIMARY)
 Sleep(800)
 MouseClick ($MOUSE_CLICK_PRIMARY)
 Sleep(800)


 MouseMove (900, 1050)       ;   "Confirm"  button
 MouseClick ($MOUSE_CLICK_PRIMARY)
 Sleep(600)

; continue the tale?
 Send("{ENTER}")
 Sleep (400)
 Send("{ENTER}")

; now wait for game to load

; siege buff

 Send ("m m m m")
 Sleep(700)
 Send ("{m down}")
 Sleep(2000)
 Send ("{m up}")
 Sleep(1000)
 Send ("{m down}")
 Sleep(1000)
 Send ("{m up}")


 MsgBox(4160, "GoGoPT", "Logging into " & StringUpper($svr), 2)
 WinActivate ($app)

; the end

